# O(1) 时间插入、删除和获取随机元素

<p>实现<code>RandomizedSet</code> 类：</p>

<div class="original__bRMd">
<div>
<ul>
	<li><code>RandomizedSet()</code> 初始化 <code>RandomizedSet</code> 对象</li>
	<li><code>bool insert(int val)</code> 当元素 <code>val</code> 不存在时，向集合中插入该项，并返回 <code>true</code> ；否则，返回 <code>false</code> 。</li>
	<li><code>bool remove(int val)</code> 当元素 <code>val</code> 存在时，从集合中移除该项，并返回 <code>true</code> ；否则，返回 <code>false</code> 。</li>
	<li><code>int getRandom()</code> 随机返回现有集合中的一项（测试用例保证调用此方法时集合中至少存在一个元素）。每个元素应该有 <strong>相同的概率</strong> 被返回。</li>
</ul>

<p>你必须实现类的所有函数，并满足每个函数的 <strong>平均</strong> 时间复杂度为 <code>O(1)</code> 。</p>

<p>&nbsp;</p>

<p><strong>示例：</strong></p>

<strong>输入</strong>

```json
["RandomizedSet", "insert", "remove", "insert", "getRandom", "remove", "insert", "getRandom"]
[[], [1], [2], [2], [], [1], [2], []]
```

<strong>输出</strong>

```json
[null, true, false, true, 2, true, false, 2]
```

<strong>解释</strong>

```java
RandomizedSet randomizedSet = new RandomizedSet();
randomizedSet.insert(1); // 向集合中插入 1 。返回 true 表示 1 被成功地插入。
randomizedSet.remove(2); // 返回 false ，表示集合中不存在 2 。
randomizedSet.insert(2); // 向集合中插入 2 。返回 true 。集合现在包含 [1,2] 。
randomizedSet.getRandom(); // getRandom 应随机返回 1 或 2 。
randomizedSet.remove(1); // 从集合中移除 1 ，返回 true 。集合现在包含 [2] 。
randomizedSet.insert(2); // 2 已在集合中，所以返回 false 。
randomizedSet.getRandom(); // 由于 2 是集合中唯一的数字，getRandom 总是返回 2 。
```

<p>&nbsp;</p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>-2<sup>31</sup> &lt;= val &lt;= 2<sup>31</sup> - 1</code></li>
	<li>最多调用 <code>insert</code>、<code>remove</code> 和 <code>getRandom</code> 函数 <code>2 *&nbsp;</code><code>10<sup>5</sup></code> 次</li>
	<li>在调用 <code>getRandom</code> 方法时，数据结构中 <strong>至少存在一个</strong> 元素。</li>
</ul>
</div>
</div>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;

```

### after

```c

```

## 答案

```c
class RandomizedSet
{
    unordered_map<int, int> dict;
    vector<int> list;

public:
    /** Initialize your data structure here. */
    RandomizedSet()
    {
        srand(time(0));
    }

    /** Inserts a value to the set. Returns true if the set did not already contain the specified element. */
    bool insert(int val)
    {
        if (dict.find(val) != dict.end())
            return false;
        list.push_back(val);
        dict[val] = list.size();
        return true;
    }

    /** Removes a value from the set. Returns true if the set contained the specified element. */
    bool remove(int val)
    {
        if (dict.find(val) == dict.end())
            return false;
        dict[list.back()] = dict[val];
        swap(list.back(), list[dict[val]]);
        list.pop_back();
        dict.erase(val);
        return true;
    }

    /** Get a random element from the set. */
    int getRandom()
    {
        int pos = list.empty() ? 0 : rand() % list.size();
        return list[pos];
    }
};
```
## 选项


### A

```c
class RandomizedSet
{
public:
    /** Initialize your data structure here. */
    RandomizedSet()
    {
    }

    /** Inserts a value to the set. Returns true if the set did not already contain the specified element. */
    bool insert(int val)
    {
        if (mMap.count(val) > 0)
            return false;

        mData.push_back(val);
        mMap[val] = mData.size() - 1;
        return true;
    }

    /** Removes a value from the set. Returns true if the set contained the specified element. */
    bool remove(int val)
    {

        if (mMap.count(val) > 0)
        {
            int last_num = mData.back();
            int val_index = mMap[val];
            mData[val_index] = last_num;
            mMap[last_num] = val_index;

            mData.pop_back();
            mMap.erase(val);

            return true;
        }

        return false;
    }

    /** Get a random element from the set. */
    int getRandom()
    {
        int index = rand() % mData.size();
        return mData[index];
    }

private:
    vector<int> mData;
    unordered_map<int, int> mMap;
};
```

### B

```c
class RandomizedSet
{
public:
    unordered_set<int> ust;

    /** Initialize your data structure here. */
    RandomizedSet()
    {
    }

    /** Inserts a value to the set. Returns true if the set did not already contain the specified element. */
    bool insert(int val)
    {
        if (ust.find(val) != ust.end())
            return false;
        ust.insert(val);
        return true;
    }

    /** Removes a value from the set. Returns true if the set contained the specified element. */
    bool remove(int val)
    {
        if (ust.find(val) == ust.end())
            return false;
        ust.erase(val);
        return true;
    }

    /** Get a random element from the set. */
    int getRandom()
    {
        int ind = rand() % ust.size();
        auto it = ust.begin();
        for (int i = 0; i < ind; i++)
        {
            it++;
        }
        return *it;
    }
};
```

### C

```c
class RandomizedSet
{
public:
    vector<int> nums;
    unordered_map<int, int> nums_inds;
    /** Initialize your data structure here. */
    RandomizedSet()
    {
    }

    /** Inserts a value to the set. Returns true if the set did not already contain the specified element. */
    bool insert(int val)
    {
        if (nums_inds.count(val) != 0)
            return false;
        nums.push_back(val);
        nums_inds[val] = nums.size() - 1;
        return true;
    }

    /** Removes a value from the set. Returns true if the set contained the specified element. */
    bool remove(int val)
    {
        if (nums_inds.count(val) == 0)
            return false;

        int last = nums.back();
        int ind = nums_inds[val];

        nums[ind] = last;
        nums_inds[last] = ind;

        nums.pop_back();
        nums_inds.erase(val);
        return true;
    }

    /** Get a random element from the set. */
    int getRandom()
    {
        int ind = rand() % nums.size();
        return nums[ind];
    }
};

```
